<?php

#********************************************************************************
#If you should have any comments, suggestions or improvements to these samples,
#we welcome you to contact us at SampleCode@melissadata.com also please visit our
#developers bulletin board at forum.melissadata.com.
#********************************************************************************

#! /usr/bin/php


include './mdAddrPHP7Wrapper.php';

#Put License and Directory of Address Object Data Files here

//********************** LICENSE STRINGS ***********************
//*     To unlock the full functionality of Address Object,    *
//*            Or to obtain a Demo License String            *
//* please call a sales representative at 1-800-MELISSA ext. 3 *
//*         (1-800-635-4772 x3) for a license string.          *
//**************************************************************/

$License = "License String";
$DataPath = "/usr/melissadata";

#Create New Object
$AddrObj = new mdAddr();

#Set License String
$AddrObj->SetLicenseString($License);

#Set Data Path and Initialize
$AddrObj->SetPathToUSFiles($DataPath);

# Add-Ons
#$AddrObj->SetPathToDPVDataFiles($DataPath);
#$AddrObj->SetPathToLACSLinkDataFiles($DataPath);
#$AddrObj->SetPathToRBDIFiles($DataPath);
#$AddrObj->SetPathToCanadaFiles($DataPath);

if($AddrObj->InitializeDataFiles() != 0)
{
  print "Cannot Initialize: ".$AddrObj->GetInitializeErrorString()."\n";
  exit;
}

# Print Initialized Information
print "\n===============================================\n";
print " Address Object PHP Interface Console Example\n";
print "           Build: ".$AddrObj->GetBuildNumber()."\n";
print "   Database Date: ".$AddrObj->GetDatabaseDate()."\n";
print "Database ExpDate: ".$AddrObj->GetExpirationDate()."\n";
print "===============================================\n\n";
#Get Input
print " Enter Address: ";
$address1 = trim(fgets(STDIN));
print "Enter Address2: ";
$address2 = trim(fgets(STDIN));
print "    Enter City: ";
$city = trim(fgets(STDIN));
print "   Enter State: ";
$state = trim(fgets(STDIN));
print "     Enter Zip: ";
$zip = trim(fgets(STDIN));

# clear any remaining properties from a previous call
$AddrObj->ClearProperties();

$AddrObj->SetAddress($address1);
$AddrObj->SetAddress2($address2);
$AddrObj->SetCity($city);
$AddrObj->SetState($state);
$AddrObj->SetZip($zip);

$result = $AddrObj->VerifyAddress();

if($result == 0)
{
  #Error with the Address
  print "Error Code:     ". $AddrObj->GetErrorCode(). "\n";
  print "Error String :     ". $AddrObj->GetErrorString(). "\n";
}
else
{
  # Display results
  print "\n";

  $ResultsString=$AddrObj->GetResults();
  if ((strstr($ResultsString,"AS01") != false) || (strstr($ResultsString,"AS02") != false) || (strstr($ResultsString,"AS03") != false))
  {
   // address was verified
      if (strstr($ResultsString,"AS01") != false)
         $Results=$Results."AS01: Full Address Matched to Postal Database and is deliverable\r\n";
      elseif (strstr($ResultsString,"AS02") != false)
         $Results=$Results."AS02: Address matched to USPS database but a suite was missing or invalid\r\n";
      elseif (strstr($ResultsString,"AS03") != false)
         $Results=$Results."AS03: Valid Physical Address not serviced by the USPS\r\n";
    }

      //Display additional level of verification/comments
    if(strstr($ResultsString,"AS09")!= false)
        $Results=$Results."AS09: Foreign Postal Code Detected \r\n";
    if (strstr($ResultsString,"AS10")!= false)
        $Results=$Results."AS10: Address Matched to CMRA\r\n";
    if (strstr($ResultsString,"AS13")!= false)
       $Results=$Results."AS13: Address has been Updated by LACSLink\r\n";
    if (strstr($ResultsString,"AS14")!= false)
        $Results=$Results."AS14: Suite Appended by SuiteLink\r\n";
    if (strstr($ResultsString,"AS15")!= false)
        $Results=$Results."AS15: Suite Appended by SuiteFinder\r\n";
    if (strstr($ResultsString,"AS16")!= false)
        $Results=$Results."AS16: Address is vacant.\r\n";
    if (strstr($ResultsString,"AS17")!= false)
        $Results=$Results."AS17: Alternate delivery.\r\n";
    if (strstr($ResultsString,"AS18")!= false)
        $Results=$Results."AS18: DPV processing was terminated artificially created adresses detected.\r\n";
    if (strstr($ResultsString,"AS20")!= false)
        $Results=$Results."AS20: Address Deliverable by USPS only \r\n";
    if (strstr($ResultsString,"AS21")!= false)
        $Results=$Results."AS21: Alternate Address Suggestion Found\r\n";
    if (strstr($ResultsString,"AS22")!= false)
         $Results=$Results."AS22: No Alternate Address Suggestion Found\r\n";
    if (strstr($ResultsString,"AS23")!= false)
        $Results=$Results."AS23: Extraneous information found \r\n";


    if (strstr($ResultsString,"AE")!= false)
    {
       //there was an error in verifying the address
       if (strstr($ResultsString,"AE01")!= false)
         $Results=$Results."AE01: Zip Code Error \r\n";
       if (strstr($ResultsString,"AE02")!= false)
         $Results=$Results."AE02: Unknown Street Error \r\n";
       if (strstr($ResultsString,"AE03")!= false)
         $Results=$Results."AE03: Component Mismatch Error \r\n";
       if (strstr($ResultsString,"AE04")!= false)
         $Results=$Results."AE04: Non-Deliverable Address Error \r\n";
       if (strstr($ResultsString,"AE05")!= false)
         $Results=$Results."AE05: Multiple Match Error \r\n";
       if (strstr($ResultsString,"AE06")!= false)
         $Results=$Results."AE06: Early Warning System Error \r\n";
       if (strstr($ResultsString,"AE07")!= false)
         $Results=$Results."AE07: Missing Minimum Address Input \r\n";
       if (strstr($ResultsString,"AE08")!= false)
         $Results=$Results."AE08: Suite Range Invalid Error\r\n";
       if (strstr($ResultsString,"AE09")!= false)
         $Results=$Results."AE09: Suite Range Missing Error \r\n";
       if (strstr($ResultsString,"AE10")!= false)
         $Results=$Results."AE10: Primary Range Invalid Error \r\n";
       if (strstr($ResultsString,"AE11")!= false)
         $Results=$Results."AE11: Primary Range Missing Error \r\n";
       if (strstr($ResultsString,"AE12")!= false)
         $Results=$Results."AE12: PO, HC, or RR Box Number Invalid \r\n";
       if (strstr($ResultsString,"AE13")!= false)
         $Results=$Results."AE13: PO, HC, or RR Box Number Missing \r\n";
       if (strstr($ResultsString,"AE14")!= false)
         $Results=$Results."AE14: CMRA Secondary Missing Error\r\n";

       // program can not attempt address lookup
       if (strstr($ResultsString,"AE15")!= false)
            $Results=$Results."AE15: Demo Mode [will only verify Nevada records]\r\n";
       if (strstr($ResultsString,"AE16")!= false)
            $Results=$Results."AE16: Expired Database, please update\r\n";

       if (strstr($ResultsString,"AE17")!= false)
        	  $Results=$Results."AE17: Unnecessary Suite Error \r\n";
       if (strstr($ResultsString,"AE19")!= false)
        	  $Results=$Results."AE19: Max time for FindSuggestion exceeded \r\n";
       if (strstr($ResultsString,"AE20")!= false)
        	  $Results=$Results."AE20: FindSuggestion cannot be used\r\n";
    }

  	//  there was a change to the input
    if (strstr($ResultsString,"AC01")!= false)
     	  $Results=$Results."AC01: ZIP Code Change \r\n";
    if (strstr($ResultsString,"AC02")!= false)
     	  $Results=$Results."AC02: State Change\r\n";
    if (strstr($ResultsString,"AC03")!= false)
     	 $Results=$Results."AC03: City Change\r\n";
    if (strstr($ResultsString,"AC04")!= false)
     	  $Results=$Results."AC04: Base/Alternate Change\r\n";
    if (strstr($ResultsString,"AC05")!= false)
     	  $Results=$Results."AC05: Alias Name Change\r\n";
    if (strstr($ResultsString,"AC06")!= false)
     	  $Results=$Results."AC06: Address1/Address2 Swap\r\n";
    if (strstr($ResultsString,"AC07")!= false)
     	  $Results=$Results."AC07: Address1/Company Swap\r\n";
    if (strstr($ResultsString,"AC08")!= false)
         $Results=$Results."AC08: Plus4 Change\r\n";
    if (strstr($ResultsString,"AC09")!= false)
     	  $Results=$Results."AC09: Urbanization Change \r\n";
    if (strstr($ResultsString,"AC10")!= false)
     	  $Results=$Results."AC10: Street Name Change\r\n";
    if (strstr($ResultsString,"AC11")!= false)
         $Results=$Results."AC11: Street Suffix Change\r\n";
    if (strstr($ResultsString,"AC12")!= false)
     	  $Results=$Results."AC12: Street Directional Change \r\n";
    if (strstr($ResultsString,"AC13")!= false)
     	  $Results=$Results."AC13: Suite Name Change \r\n";


  print "Result Code(s)...\n"  .$Results. "\n";


  print "      Address1: ". $AddrObj->GetAddress(). "\n";
  print "      Address2: ". $AddrObj->GetAddress2(). "\n";
  print "         Suite: ". $AddrObj->GetSuite(). "\n";
  print "           PMB: ". $AddrObj->GetPrivateMailBox(). "\n";
  print "          City: ". $AddrObj->GetCity(). "\n";
  print "         State: ". $AddrObj->GetState(). "\n";
  print "           Zip: ". $AddrObj->GetZip(). "\n";
  print "         Plus4: ". $AddrObj->GetPlus4(). "\n";
  print "          CRRT: ". $AddrObj->GetCarrierRoute(). "\n";
  print " DeliveryPoint: ". $AddrObj->GetDeliveryPointCode(). "\n";
  print "        County: ". $AddrObj->GetCountyName(). "\n";
  print "  Country Code: ". $AddrObj->GetCountryCode(). "\n";



    }



?>
